package com.estimote.indoorsdk_module.dagger.indoor_manager

import com.estimote.indoorsdk_module.algorithm.IndoorLocationManager
import com.estimote.indoorsdk_module.algorithm.ScanningEstimoteIndoorLocationManager
import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class ScanningModule(private val bluetoothScanner: BluetoothScanner,
                              private val indoorLocationManager: IndoorLocationManager) {


    @Provides
    @Singleton
    fun provideSBluetoothScanner() : BluetoothScanner = bluetoothScanner

    @Provides
    @Singleton
    fun provideScanningIndoorLocationManager(bluetoothScanner: BluetoothScanner): ScanningEstimoteIndoorLocationManager {
        return ScanningEstimoteIndoorLocationManager(indoorLocationManager, bluetoothScanner)

    }
}