package com.estimote.indoorsdk_module.common.extensions

import com.estimote.indoorsdk_module.algorithm.geometry.PlanarGeometry
import com.estimote.indoorsdk_module.algorithm.geometry.Point2D
import com.estimote.indoorsdk_module.cloud.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

internal fun Location.translateAllCoordinatesToPositiveValues(): Location {
    val minX = this.getMinX()
    val minY = this.getMinY()
    val translatedWalls = this.walls.map { LocationWall(it.x1 - minX, it.y1 - minY, it.x2 - minX, it.y2 - minY, it.orientation) }
    val translatedBeacons = this.beacons.map { LocationBeacon(it.beacon, LocationPosition(it.position.x - minX, it.position.y - minY, it.position.orientation)) }
    val translatedLinearObjects = this.linearObjects.map { LocationLinearObject(it.x1 - minX, it.y1 - minY, it.x2 - minX, it.y2 - minY, it.orientation, it.type) }
    return Location(name, identifier, public, owner, orientation, translatedWalls, translatedBeacons, translatedLinearObjects)
}

internal fun Location.getMaxX(): Double {
    return walls.flatMap { listOf(it.x1, it.x2) }.max() ?: 0.0
}

internal fun Location.getMaxY(): Double {
    return walls.flatMap { listOf(it.y1, it.y2) }.max() ?: 0.0
}

internal fun Location.getMinX(): Double {
    return walls.flatMap { listOf(it.x1, it.x2) }.min() ?: 0.0
}

internal fun Location.getMinY(): Double {
    return walls.flatMap { listOf(it.y1, it.y2) }.min() ?: 0.0
}

/**
 * Calculates distance between from this [LocationPosition] to another one.
 * @return distance in meters.
 */
fun LocationPosition.distanceTo(anotherPosition: LocationPosition): Double{
    return PlanarGeometry().distanceBetweenPoints(Point2D(this.x, this.y), Point2D(anotherPosition.x, anotherPosition.y))
}