package com.estimote.indoorsdk_module.cloud

import android.content.Context
import android.support.annotation.Keep
import com.estimote.indoorsdk_module.dagger.cloud_manager.DaggerIndoorCloudManagerComponent
import com.estimote.indoorsdk_module.dagger.cloud_manager.IndoorCloudManagerModule
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import javax.inject.Inject

/**
 * Provides you with [IndoorCloudManager] objects for communicating with Estimote Indoor Cloud.
 *
 * @see IndoorCloudManager
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Keep
class IndoorCloudManagerFactory {

    @Inject
    internal lateinit var indoorCloudManager: IndoorCloudManager

    /**
     * Creates concrete object for communicating with Estimote Indoor Cloud.
     * You need to provide it with [Context] class.
     * @return IndoorCloudManager object
     */
    fun create(context: Context, cloudCredentials: CloudCredentials) : IndoorCloudManager {
       DaggerIndoorCloudManagerComponent.builder()
               .indoorCloudManagerModule(IndoorCloudManagerModule(context, cloudCredentials))
               .build().inject(this)
        return indoorCloudManager
    }

}