package com.estimote.indoorsdk_module.algorithm.sensor

import com.estimote.indoorsdk_module.common.config.Config
import com.estimote.indoorsdk_module.common.time.Timer

/**
 *
 * Detects user motion from steps.
 * User is assumed to be in motion, when a sequence of X steps occur.
 * User is assumed not to be in motion, when last step occurred later then threshold.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

internal class StepMotionDetector(private val timer: Timer,
                                  private val config: Config) : MotionDetector {

    private val INITIAL_EVENT = EstimoteSensorEvent(timestampMillis = -1)

    private var isInMotion = false
    private var sequenceCounter: Int = 0
    private var previousEvent = INITIAL_EVENT

    override fun onEvent(event: EstimoteSensorEvent) {
        if (previousEvent == INITIAL_EVENT) {
            previousEvent = event
            return
        }
        if (event.timestampMillis - previousEvent.timestampMillis < config.getStepThreshold().toMillis()) {
            if (sequenceCounter == config.getStepSequenceNumber()) {
                isInMotion = true
            } else {
                sequenceCounter++
            }
        }
        previousEvent = event
    }

    override fun isInMotion(): Boolean {
        if (timer.getEpochTimeMillis() - previousEvent.timestampMillis > config.getStepThreshold().toMillis()) {
            isInMotion = false
            sequenceCounter = 0
        }
        return isInMotion
    }

    private fun Double.toMillis() = this * 1000


}