package com.estimote.indoorsdk_module.algorithm.filter

import com.estimote.indoorsdk_module.algorithm.distance.StatefulDistanceCalculator
import com.estimote.indoorsdk_module.algorithm.model.BeaconWithDistance

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class HumanWalkStatefulDistanceFilter(private val statefulDistanceCalculator: StatefulDistanceCalculator) : DistanceFilter {

    private var previouslyFilteredList = emptyList<BeaconWithDistance>()

    override fun filter(beacons: List<BeaconWithDistance>): List<BeaconWithDistance> {
        return beacons.mapToPreviousDistances(previouslyFilteredList)
                .applyHumanWalkFiltering(statefulDistanceCalculator)
                .savePreviousState()
    }

    private fun List<BeaconWithDistance>.mapToPreviousDistances(previousDistances: List<BeaconWithDistance>): List<Pair<BeaconWithDistance?, BeaconWithDistance>> {
        return map { newDistance ->
            val previousDistance: BeaconWithDistance? = previousDistances.find { it.beacon == newDistance.beacon }
            return@map previousDistance to newDistance
        }
    }

    private fun List<Pair<BeaconWithDistance?, BeaconWithDistance>>.applyHumanWalkFiltering(statefulDistanceCalculator: StatefulDistanceCalculator): List<BeaconWithDistance> =
            map { statefulDistanceCalculator.calculateDistance(it.first, it.second) }

    private fun List<BeaconWithDistance>.savePreviousState(): List<BeaconWithDistance> {
        previouslyFilteredList = this
        return this
    }
}