package com.estimote.indoorsdk_module.algorithm.filter

import com.estimote.indoorsdk_module.algorithm.model.BeaconWithDistance
import com.estimote.indoorsdk_module.common.config.ConfigFactory

/**
 * Filters out any beacons that are closer then given threshold.
 *
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class ClosestBeaconDistanceFilter(private val configFactory: ConfigFactory) : DistanceFilter {

    override fun filter(beacons: List<BeaconWithDistance>): List<BeaconWithDistance> {
        val sortedBeacons = beacons.sortedBy { it.distance }
        return beacons
                .filter { it.distance < (sortedBeacons[0].distance * configFactory.getConfig().getClosestBeaconDistanceThreshold()) }
                .filter { it.distance < configFactory.getConfig().getMaxDistanceToBeInsideLocation() }
    }
}