package com.estimote.indoorsdk_module.algorithm

import android.util.Log
import com.estimote.internal_plugins_api.scanning.BluetoothScanner

internal class ScanningEstimoteIndoorLocationManager(private val indoorLocationManager: IndoorLocationManager,
                                            private val bluetoothScanner: BluetoothScanner) : ScanningIndoorLocationManager {

    private lateinit var estimoteLocationScanHandler: BluetoothScanner.ScanHandler
    private lateinit var ibeaconScanHandler: BluetoothScanner.ScanHandler

    override fun startPositioning() {
        indoorLocationManager.startPositioning()
        estimoteLocationScanHandler = bluetoothScanner.estimoteLocationScan()
                .withLowLatencyPowerMode()
                .withOnPacketFoundAction { indoorLocationManager.onScannedLocationPackets(it) }
                .withOnScanErrorAction { Log.d("Estimote", "EstimoteLocation scan error: ${it.printStackTrace()}" ) }
                .start()
        ibeaconScanHandler = bluetoothScanner.beaconScan()
                .withLowLatencyPowerMode()
                .withOnPacketFoundAction { indoorLocationManager.onScannedBeaconPackets(it) }
                .withOnScanErrorAction { Log.d("Estimote", "iBeacon scan error:  ${it.printStackTrace()}" + it.message) }
                .start()
    }

    override fun stopPositioning() {
        estimoteLocationScanHandler.stop()
        ibeaconScanHandler.stop()
        indoorLocationManager.stopPositioning()
    }

    override fun setOnPositionUpdateListener(onPositionUpdateListener: OnPositionUpdateListener) {
        indoorLocationManager.setOnPositionUpdateListener(onPositionUpdateListener)
    }

}