/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.api;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/estimote/cloud_plugin/api/AuthorizationHeaderInterceptor;", "Lokhttp3/Interceptor;", "appId", "", "appToken", "(Ljava/lang/String;Ljava/lang/String;)V", "authString", "kotlin.jvm.PlatformType", "buildBasicAuthHeader", "Lokhttp3/Request;", "chain", "Lokhttp3/Interceptor$Chain;", "intercept", "Lokhttp3/Response;", "cloud-plugin_release"})
public final class AuthorizationHeaderInterceptor
implements Interceptor {
    private final String authString;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Response response = chain.proceed(this.buildBasicAuthHeader(chain));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(buildBasicAuthHeader(chain))");
        return response;
    }

    private final Request buildBasicAuthHeader(Interceptor.Chain chain) {
        return chain.request().newBuilder().addHeader("Authorization", "Basic " + this.authString).build();
    }

    public AuthorizationHeaderInterceptor(@NotNull String appId, @NotNull String appToken) {
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)appToken, (String)"appToken");
        this.authString = ByteString.encodeUtf8((String)("" + appId + ':' + appToken)).base64();
    }
}

