/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.api;

import com.estimote.cloud_plugin.api.AuthorizationHeaderInterceptor;
import com.estimote.cloud_plugin.api.ContentTypeHeaderInterceptor;
import com.estimote.cloud_plugin.api.DeserializerConfig;
import com.estimote.cloud_plugin.api.DeviceInfo;
import com.estimote.cloud_plugin.api.SdkInfo;
import com.estimote.cloud_plugin.api.UserAgentHeaderInterceptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a)\u0010\u0000\u001a\u00020\u00012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\"\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001ac\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\"\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0012\u001a!\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0003\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"createGson", "Lcom/google/gson/Gson;", "deserializers", "", "Lcom/estimote/cloud_plugin/api/DeserializerConfig;", "([Lcom/estimote/cloud_plugin/api/DeserializerConfig;)Lcom/google/gson/Gson;", "createRestApi", "T", "apiClass", "Ljava/lang/Class;", "baseUrl", "", "appId", "appToken", "sdkInfo", "Lcom/estimote/cloud_plugin/api/SdkInfo;", "deviceInfo", "Lcom/estimote/cloud_plugin/api/DeviceInfo;", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/estimote/cloud_plugin/api/SdkInfo;Lcom/estimote/cloud_plugin/api/DeviceInfo;[Lcom/estimote/cloud_plugin/api/DeserializerConfig;)Ljava/lang/Object;", "getHttpClient", "Lokhttp3/OkHttpClient;", "interceptors", "Lokhttp3/Interceptor;", "([Lokhttp3/Interceptor;)Lokhttp3/OkHttpClient;", "cloud-plugin_release"})
public final class ApiKt {
    public static final <T> T createRestApi(@NotNull Class<T> apiClass, @NotNull String baseUrl, @NotNull String appId, @NotNull String appToken, @NotNull SdkInfo sdkInfo, @NotNull DeviceInfo deviceInfo, DeserializerConfig<?> ... deserializers) {
        Intrinsics.checkParameterIsNotNull(apiClass, (String)"apiClass");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)appToken, (String)"appToken");
        Intrinsics.checkParameterIsNotNull((Object)sdkInfo, (String)"sdkInfo");
        Intrinsics.checkParameterIsNotNull((Object)deviceInfo, (String)"deviceInfo");
        Intrinsics.checkParameterIsNotNull(deserializers, (String)"deserializers");
        return (T)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiKt.createGson(Arrays.copyOf(deserializers, deserializers.length)))).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(ApiKt.getHttpClient(new ContentTypeHeaderInterceptor(), new AuthorizationHeaderInterceptor(appId, appToken), new UserAgentHeaderInterceptor(sdkInfo, deviceInfo))).build().create(apiClass);
    }

    private static final OkHttpClient getHttpClient(Interceptor ... interceptors) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        for (Object element$iv : (Object[])interceptors) {
            Interceptor it = (Interceptor)element$iv;
            clientBuilder.addInterceptor(it);
        }
        OkHttpClient okHttpClient = clientBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"clientBuilder.build()");
        return okHttpClient;
    }

    private static final Gson createGson(DeserializerConfig<?> ... deserializers) {
        GsonBuilder gsonBuilder;
        GsonBuilder $receiver = gsonBuilder = new GsonBuilder();
        for (Object element$iv : (Object[])deserializers) {
            DeserializerConfig it = (DeserializerConfig)element$iv;
            $receiver.registerTypeAdapter(it.getTypeToken().getType(), it.getJsonDeserializer());
        }
        $receiver.enableComplexMapKeySerialization();
        $receiver.serializeNulls();
        $receiver.setPrettyPrinting();
        Gson gson = $receiver.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"create()");
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"with(GsonBuilder()) {\n  \u2026()\n        create()\n    }");
        return gson;
    }
}

