/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.analytics;

import com.estimote.cloud_plugin.analytics.model.CloudAnalyticsEvent;
import com.estimote.cloud_plugin.analytics.model.CloudAnalyticsEventsBatch;
import com.estimote.cloud_plugin.analytics.model.CloudTelemetryBatch;
import com.estimote.cloud_plugin.analytics.model.CloudTelemetryModel;
import com.estimote.cloud_plugin.analytics.model.Motion;
import com.estimote.cloud_plugin.analytics.model.Vector;
import com.estimote.cloud_plugin.analytics.model.Warnings;
import com.estimote.cloud_plugin.analytics.rest.AnalyticsCloudRestApi;
import com.estimote.internal_plugins_api.analytics.proximity.ProximityAnalyticsEvent;
import com.estimote.internal_plugins_api.cloud.analytics.AnalyticsCloud;
import com.estimote.internal_plugins_api.scanning.Duration;
import com.estimote.internal_plugins_api.scanning.EstimoteTelemetryFull;
import io.reactivex.Completable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b*\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0006H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\f*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/estimote/cloud_plugin/analytics/EstimoteAnalyticsCloud;", "Lcom/estimote/internal_plugins_api/cloud/analytics/AnalyticsCloud;", "analyticsCloudRestApi", "Lcom/estimote/cloud_plugin/analytics/rest/AnalyticsCloudRestApi;", "(Lcom/estimote/cloud_plugin/analytics/rest/AnalyticsCloudRestApi;)V", "postProximityAnalyticsEvents", "Lio/reactivex/Completable;", "events", "", "Lcom/estimote/internal_plugins_api/analytics/proximity/ProximityAnalyticsEvent;", "postProximityUsageMetrics", "deviceId", "", "postTelemetry", "telemetryFull", "Lcom/estimote/internal_plugins_api/scanning/EstimoteTelemetryFull;", "timestampMillis", "", "convertToCloudModels", "Lcom/estimote/cloud_plugin/analytics/model/CloudAnalyticsEvent;", "executeInBackground", "notifyOnMainThread", "toCloudModel", "Lcom/estimote/cloud_plugin/analytics/model/CloudTelemetryModel;", "toMillis", "Lcom/estimote/internal_plugins_api/scanning/Duration;", "toSeconds", "cloud-plugin_release"})
public final class EstimoteAnalyticsCloud
implements AnalyticsCloud {
    private final AnalyticsCloudRestApi analyticsCloudRestApi;

    @NotNull
    public Completable postProximityAnalyticsEvents(@NotNull List<ProximityAnalyticsEvent> events) {
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        return this.notifyOnMainThread(this.executeInBackground(this.analyticsCloudRestApi.postAnalyticsEvents(new CloudAnalyticsEventsBatch(this.convertToCloudModels(events)))));
    }

    @NotNull
    public Completable postProximityUsageMetrics(@NotNull String deviceId) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        return this.notifyOnMainThread(this.executeInBackground(this.analyticsCloudRestApi.getZonesBounds(deviceId)));
    }

    @NotNull
    public Completable postTelemetry(@NotNull EstimoteTelemetryFull telemetryFull, long timestampMillis) {
        Intrinsics.checkParameterIsNotNull((Object)telemetryFull, (String)"telemetryFull");
        return this.notifyOnMainThread(this.executeInBackground(this.analyticsCloudRestApi.postTelemetry(new CloudTelemetryBatch(CollectionsKt.listOf((Object)this.toCloudModel(telemetryFull, timestampMillis))))));
    }

    /*
     * WARNING - void declaration
     */
    private final List<CloudAnalyticsEvent> convertToCloudModels(@NotNull List<ProximityAnalyticsEvent> $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            CloudAnalyticsEvent cloudAnalyticsEvent;
            void it;
            ProximityAnalyticsEvent proximityAnalyticsEvent = (ProximityAnalyticsEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = it.getEventType().name();
            CloudAnalyticsEvent cloudAnalyticsEvent2 = cloudAnalyticsEvent;
            CloudAnalyticsEvent cloudAnalyticsEvent3 = cloudAnalyticsEvent;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            String string5 = string4;
            String string6 = string2 = it.getPacketType().name();
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string6.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            cloudAnalyticsEvent2(string5, string, it.getPacketIdentifier(), it.getExpectedDistance(), it.isInForeground(), it.getDistinctId(), this.toSeconds(it.getTimestampMillis()));
            CloudAnalyticsEvent cloudAnalyticsEvent4 = cloudAnalyticsEvent3;
            collection.add(cloudAnalyticsEvent4);
        }
        return (List)destination$iv$iv;
    }

    private final CloudTelemetryModel toCloudModel(@NotNull EstimoteTelemetryFull $receiver, long timestampMillis) {
        CloudTelemetryModel cloudTelemetryModel;
        String string = $receiver.getIdentifier();
        CloudTelemetryModel cloudTelemetryModel2 = cloudTelemetryModel;
        CloudTelemetryModel cloudTelemetryModel3 = cloudTelemetryModel;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        cloudTelemetryModel2(string4, new Vector($receiver.getAcceleration().getXAxis(), $receiver.getAcceleration().getYAxis(), $receiver.getAcceleration().getZAxis()), new Vector($receiver.getMagnetometer().getXAxis(), $receiver.getMagnetometer().getYAxis(), $receiver.getMagnetometer().getZAxis()), new Motion($receiver.getMotionState(), this.toMillis($receiver.getCurrentMotionDuration()), this.toMillis($receiver.getPreviousMotionDuration())), (int)$receiver.getTemperatureInCelsiusDegrees(), (int)$receiver.getAmbientLightInLux(), $receiver.getBatteryVoltageInMilliVolts(), this.toMillis($receiver.getUptime()), timestampMillis, new Warnings(false, false));
        return cloudTelemetryModel3;
    }

    private final Completable executeInBackground(@NotNull Completable $receiver) {
        Completable completable = $receiver.subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.subscribeOn(Schedulers.io())");
        return completable;
    }

    private final Completable notifyOnMainThread(@NotNull Completable $receiver) {
        Completable completable = $receiver.observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.observeOn(AndroidSchedulers.mainThread())");
        return completable;
    }

    private final long toMillis(@NotNull Duration $receiver) {
        return $receiver.getTimeUnit().convert($receiver.getValue(), TimeUnit.MILLISECONDS);
    }

    private final String toSeconds(long $receiver) {
        String string = new BigDecimal((double)$receiver / 1000.0).setScale(2, 4).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BigDecimal(this / 1000.0\u2026ROUND_HALF_UP).toString()");
        return string;
    }

    public EstimoteAnalyticsCloud(@NotNull AnalyticsCloudRestApi analyticsCloudRestApi) {
        Intrinsics.checkParameterIsNotNull((Object)analyticsCloudRestApi, (String)"analyticsCloudRestApi");
        this.analyticsCloudRestApi = analyticsCloudRestApi;
    }
}

