package com.estimote.cloud_plugin.secure.rest.gson

import com.estimote.cloud_plugin.secure.model.FrameType
import com.google.gson.*
import java.lang.reflect.Type

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class FrameTypeDeserializer : JsonDeserializer<FrameType> {

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?) =
            json?.asString?.mapToEnum() ?: FrameType.UNKNOWN

    private fun String.mapToEnum() = when(this) {
        "location" -> FrameType.LOCATION
        "connectivity" -> FrameType.CONNECTIVITY
        else -> FrameType.UNKNOWN
    }

}