package com.estimote.cloud_plugin.secure.model

import com.google.gson.annotations.SerializedName

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal data class DecryptedPacketResponse(@SerializedName("data") val decryptedPacket: DecryptedPacket)

internal data class DecryptedPacket(
        @SerializedName("frame_type") val frameType: FrameType,
        @SerializedName("protocol_version") val protocolVersion: Float,
        @SerializedName("measured_power") val measuredPower: Int,
        @SerializedName("adv_channel") val channel: Int,
        @SerializedName("public_id") val deviceId: String
)

internal enum class FrameType { LOCATION, CONNECTIVITY, UNKNOWN }