package com.estimote.cloud_plugin.secure.dagger

import android.content.Context
import com.estimote.cloud_plugin.common.*
import com.estimote.cloud_plugin.secure.EstimoteLocationSecureCloud
import com.estimote.cloud_plugin.secure.rest.SecureCloudRestApi
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.secure.ResolvedEstimoteLocation
import com.estimote.internal_plugins_api.cloud.secure.SecureCloud
import com.estimote.internal_plugins_api.common.DeviceGeneralInfo
import com.estimote.internal_plugins_api.common.DeviceGeneralInfoProvider
import com.estimote.internal_plugins_api.scanning.EstimoteLocation
import com.google.gson.Gson
import dagger.Module
import dagger.Provides

/**
 * @author Estimote Inc. (contact@estimote.com)
 */

@Module
internal class SecureCloudModule(private val appContext: Context,
                                 private val cloudEndpoint: String,
                                 private val sdkInfo: CloudSdkInfo,
                                 private val cloudCredentials: CloudCredentials) {

    @Provides
    @SecureCloudScope
    internal fun provideCloudCredentials() = cloudCredentials

    @Provides
    @SecureCloudScope
    internal fun provideSharedPreferencesProvider(): SharedPreferencesProvider = SharedPreferencesProvider(appContext)

    @Provides
    @SecureCloudScope
    internal fun provideGson(gsonFactory: GsonFactory): Gson = gsonFactory.createGson()

    @Provides
    @SecureCloudScope
    internal fun provideDeviceGeneralInfoProvider(): DeviceGeneralInfoProvider = CommonDeviceGeneralInfoProvider()

    @Provides
    @SecureCloudScope
    internal fun provideDeviceGeneralInfo(generalInfoProvider: DeviceGeneralInfoProvider) = generalInfoProvider.provideGeneralInfo(appContext)

    @Provides
    @SecureCloudScope
    internal fun provideUserAgentProvider(generalInfo: DeviceGeneralInfo) = CloudUserAgentProvider(sdkInfo, generalInfo)

    @Provides
    @SecureCloudScope
    internal fun provideCloudRestApi(cloudApiFactory: CloudApiFactory): SecureCloudRestApi = cloudApiFactory.createRestApiFactory(cloudEndpoint, SecureCloudRestApi::class.java)

    @Provides
    @SecureCloudScope
    internal fun provideSecureCloud(restApi: SecureCloudRestApi): SecureCloud<ResolvedEstimoteLocation> = EstimoteLocationSecureCloud(restApi)
}