package com.estimote.cloud_plugin.secure

import android.util.Log
import com.estimote.android_ketchup.kotlin_goodness.toHexString
import com.estimote.cloud_plugin.common.exception.WrongFrameTypeException
import com.estimote.cloud_plugin.secure.model.DecryptedPacket
import com.estimote.cloud_plugin.secure.model.FrameType
import com.estimote.cloud_plugin.secure.rest.SecureCloudRestApi
import com.estimote.internal_plugins_api.cloud.secure.ResolvedEstimoteLocation
import com.estimote.internal_plugins_api.cloud.secure.SecureCloud
import com.estimote.internal_plugins_api.scanning.EstimoteSecure
import io.reactivex.Single
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class EstimoteLocationSecureCloud(private val api: SecureCloudRestApi) : SecureCloud<ResolvedEstimoteLocation> {

    override fun resolvePacket(packet: EstimoteSecure): Single<ResolvedEstimoteLocation> {
        return api
                .decryptSecureFrame(packet.payload.toHexString())
                .doOnSuccess { if (it.decryptedPacket.frameType != FrameType.LOCATION) throw WrongFrameTypeException() }
                .map { it.decryptedPacket.toResolvedEstimoteLocation() }
                .executeInBackground()
                .notifyOnMainThread()
    }

    private fun DecryptedPacket.toResolvedEstimoteLocation(): ResolvedEstimoteLocation {
        return object : ResolvedEstimoteLocation {
            override val deviceId = this@toResolvedEstimoteLocation.deviceId
            override val channel = this@toResolvedEstimoteLocation.channel
            override val protocolVersion = (this@toResolvedEstimoteLocation.protocolVersion * 10).toInt()
            override val measuredPower = this@toResolvedEstimoteLocation.measuredPower
        }
    }

    private fun <T> Single<T>.executeInBackground(): Single<T> =
            this.subscribeOn(Schedulers.io())

    private fun <T> Single<T>.notifyOnMainThread(): Single<T> =
            this.observeOn(AndroidSchedulers.mainThread())


}