package com.estimote.cloud_plugin.proximity.model

import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachment

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteProximityAttachment(private val deviceId: String?,
                                  private val payload: Map<String, String>?) : ProximityAttachment {

    override fun getDeviceId() = deviceId ?: ""

    @Deprecated(message = "Use method getPayload and access specific key/value pair")
    override fun hasPair(key: String, value: String?): Boolean {
        return if (value != null) {
            hasKeyAndValue(key, value)
        } else hasKey(key)
    }

    override fun hasAttachment(): Boolean = payload != null

    override fun getPayload(): Map<String, String> = payload.orEmpty()

    private fun hasKey(key: String) = payload?.containsKey(key) ?: false

    private fun hasKeyAndValue(key: String, value: String) = payload?.get(key)?.compareTo(value) == 0 ?: false
}