package com.estimote.cloud_plugin.management.internal.rest.gson

import com.estimote.internal_plugins_api.cloud.management.CloudCommands
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import java.lang.reflect.Type

internal class CloudCommandsDeserializer: JsonDeserializer<CloudCommands> {

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?) = CloudCommands(getCommands(json))

    private fun getCommands(json: JsonElement?) = getDataArray(json)?.map { it.asString } ?: listOf<String>()

    private fun getDataArray(json: JsonElement?) = json?.asJsonObject?.getAsJsonArray("data")
}