package com.estimote.cloud_plugin.internal.rest.gson


import com.estimote.internal_plugins_api.cloud.management.CloudMeshConfig
import com.estimote.internal_plugins_api.cloud.management.CloudMeshConfigs
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import java.lang.reflect.Type

internal class CloudMeshConfigsDeserializer : JsonDeserializer<CloudMeshConfigs> {
    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?) =
            CloudMeshConfigs( getMeshConfigsList(json))

    private fun getMeshConfigsList(json: JsonElement?) =
            json?.asJsonArray?.map { CloudMeshConfig(getMeshId(it), getDevicesIds(it)) } ?: listOf()

    private fun getDevicesIds(it: JsonElement) =
            it.asJsonObject.getAsJsonArray("devices").map { it.asString }

    private fun getMeshId(it: JsonElement) =
            it.asJsonObject.getAsJsonPrimitive("mesh_identifier").asLong

}