package com.estimote.cloud_plugin.analytics.model

import com.google.gson.annotations.SerializedName

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal data class CloudTelemetryModel(
        @SerializedName("identifier")
        val identifier: String,
        @SerializedName("acceleration")
        val acceleration: Vector,
        @SerializedName("magnetic_field")
        val magneticField: Vector,
        @SerializedName("motion")
        val motion: Motion,
        @SerializedName("temperature")
        val temperature: Int,
        @SerializedName("ambient_light_level")
        val ambientLight: Int,
        @SerializedName("battery_voltage")
        val batteryVoltage: Int,
        @SerializedName("uptime")
        val uptime: Long,
        @SerializedName("scanned_at")
        val timestamp: Long,
        @SerializedName("warnings")
        val warnings: Warnings
)

internal data class Motion(
        @SerializedName("current_state")
        val currentState: Boolean,
        @SerializedName("current_state_duration")
        val currentStateDuration: Long,
        @SerializedName("previous_state_duration")
        val previousStateDuration: Long
)

internal data class Warnings(
        @SerializedName("application_error")
        val applicationError: Boolean,
        @SerializedName("rtc_error")
        val rtcError: Boolean
)

internal class Vector(
        @SerializedName("x")
        val x: Double,
        @SerializedName("y")
        val y: Double,
        @SerializedName("z")
        val z: Double)