/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.management.internal;

import com.estimote.cloud_plugin.management.internal.EstimoteManagementCloud;
import com.estimote.cloud_plugin.management.internal.MeshSettingsVersionUpdateFactory;
import com.estimote.cloud_plugin.management.internal.dagger.model.MeshId;
import com.estimote.cloud_plugin.management.internal.rest.ManagementCloudRestApi;
import com.estimote.internal_plugins_api.cloud.management.BufferConfirmationMessage;
import com.estimote.internal_plugins_api.cloud.management.CloudCommands;
import com.estimote.internal_plugins_api.cloud.management.CloudDeviceId;
import com.estimote.internal_plugins_api.cloud.management.CloudMeshConfig;
import com.estimote.internal_plugins_api.cloud.management.CloudMeshMessage;
import com.estimote.internal_plugins_api.cloud.management.CloudMeshMessageBody;
import com.estimote.internal_plugins_api.cloud.management.CloudMeshSettingsVersion;
import com.estimote.internal_plugins_api.cloud.management.ManagementCloud;
import com.estimote.internal_plugins_api.cloud.management.MeshScanReport;
import com.estimote.internal_plugins_api.cloud.management.MeshScanReportResponse;
import com.estimote.internal_plugins_api.cloud.management.MeshSettingsConfirmationRequest;
import com.estimote.internal_plugins_api.cloud.management.MeshSettingsConfirmationResponse;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00110\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0018H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\t\u001a\u00020&2\u0006\u0010 \u001a\u00020\u0018H\u0016J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e*\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0002J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e*\b\u0012\u0004\u0012\u00020\u00180\u000eH\u0002J\f\u0010)\u001a\u00020\b*\u00020\bH\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\u000e\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0\u000eH\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e*\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0002J\f\u0010,\u001a\u00020\b*\u00020\bH\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u0002H*0\u000e\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0\u000eH\u0002J\n\u0010-\u001a\u00020&*\u00020.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/estimote/cloud_plugin/management/internal/EstimoteManagementCloud;", "Lcom/estimote/internal_plugins_api/cloud/management/ManagementCloud;", "restApiManagement", "Lcom/estimote/cloud_plugin/management/internal/rest/ManagementCloudRestApi;", "(Lcom/estimote/cloud_plugin/management/internal/rest/ManagementCloudRestApi;)V", "HEX_CHARS", "", "confirmCommands", "Lio/reactivex/Completable;", "deviceId", "Lcom/estimote/internal_plugins_api/cloud/management/CloudDeviceId;", "cloudCommands", "Lcom/estimote/internal_plugins_api/cloud/management/CloudCommands;", "confirmMeshSettings", "Lio/reactivex/Observable;", "Lcom/estimote/internal_plugins_api/cloud/management/MeshSettingsConfirmationResponse;", "confirmationRequests", "", "Lcom/estimote/internal_plugins_api/cloud/management/MeshSettingsConfirmationRequest;", "deleteCommands", "getCommandsForDevice", "getMeshIdForDevice", "Lcom/estimote/cloud_plugin/management/internal/dagger/model/MeshId;", "getMeshMessageForDevice", "Lcom/estimote/internal_plugins_api/cloud/management/CloudMeshMessage;", "getMeshSettingsVersion", "Lcom/estimote/internal_plugins_api/cloud/management/CloudMeshSettingsVersion;", "meshId", "", "getMeshesList", "Lcom/estimote/internal_plugins_api/cloud/management/CloudMeshConfig;", "putMeshMessageBuffer", "cloudMessage", "sendMeshScanReport", "Lcom/estimote/internal_plugins_api/cloud/management/MeshScanReportResponse;", "meshScanReport", "Lcom/estimote/internal_plugins_api/cloud/management/MeshScanReport;", "updateSettingsVersion", "", "completeIfThereIsNoMeshConfigured", "completeIfThereIsNoMessageForDevice", "executeInBackground", "T", "mapToMeshMessage", "notifyOnMainThread", "toHexString", "", "cloud-plugin_release"})
public final class EstimoteManagementCloud
implements ManagementCloud {
    private final char[] HEX_CHARS;
    private final ManagementCloudRestApi restApiManagement;

    @NotNull
    public Observable<CloudMeshMessage> getMeshMessageForDevice(@NotNull CloudDeviceId deviceId) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        return this.notifyOnMainThread(this.executeInBackground(this.completeIfThereIsNoMessageForDevice(this.mapToMeshMessage(this.completeIfThereIsNoMeshConfigured(this.getMeshIdForDevice(deviceId))))));
    }

    @NotNull
    public Observable<CloudMeshMessage> updateSettingsVersion(@NotNull String deviceId, @NotNull CloudMeshMessage cloudMessage) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        Intrinsics.checkParameterIsNotNull((Object)cloudMessage, (String)"cloudMessage");
        Observable observable = this.restApiManagement.updateSettingsVersion(deviceId, new MeshSettingsVersionUpdateFactory().create(deviceId, cloudMessage.getSettingsVersion())).map(new Function<T, R>(cloudMessage){
            final /* synthetic */ CloudMeshMessage $cloudMessage;

            @NotNull
            public final CloudMeshMessage apply(@NotNull ManagementCloud.RequestStatus it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$cloudMessage;
            }
            {
                this.$cloudMessage = cloudMeshMessage;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"restApiManagement.update\u2026    .map { cloudMessage }");
        return this.notifyOnMainThread(this.executeInBackground(observable));
    }

    @NotNull
    public Completable putMeshMessageBuffer(@NotNull CloudMeshMessage cloudMessage) {
        Intrinsics.checkParameterIsNotNull((Object)cloudMessage, (String)"cloudMessage");
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.putMeshMessageBuffer(cloudMessage.getMeshId(), new BufferConfirmationMessage(this.toHexString(cloudMessage.getData())))));
    }

    @NotNull
    public Observable<CloudCommands> getCommandsForDevice(@NotNull CloudDeviceId deviceId) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.getCommandsForDevice(deviceId.getId())));
    }

    @NotNull
    public Completable deleteCommands(@NotNull CloudDeviceId deviceId) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.deleteCommands(deviceId.getId())));
    }

    @NotNull
    public Completable confirmCommands(@NotNull CloudDeviceId deviceId, @NotNull CloudCommands cloudCommands) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        Intrinsics.checkParameterIsNotNull((Object)cloudCommands, (String)"cloudCommands");
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.confirmCommands(deviceId.getId(), cloudCommands)));
    }

    @NotNull
    public Observable<List<CloudMeshConfig>> getMeshesList() {
        Observable observable = this.restApiManagement.getMeshesList().map((Function)getMeshesList.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"restApiManagement.getMes\u2026p { it.cloudMeshConfigs }");
        return this.notifyOnMainThread(this.executeInBackground(observable));
    }

    @NotNull
    public Observable<CloudMeshSettingsVersion> getMeshSettingsVersion(long meshId) {
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.getMeshSettingsVersion(meshId)));
    }

    @NotNull
    public Observable<MeshSettingsConfirmationResponse> confirmMeshSettings(@NotNull List<MeshSettingsConfirmationRequest> confirmationRequests) {
        Intrinsics.checkParameterIsNotNull(confirmationRequests, (String)"confirmationRequests");
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.confirmMeshSettings(confirmationRequests)));
    }

    @NotNull
    public Observable<MeshScanReportResponse> sendMeshScanReport(@NotNull MeshScanReport meshScanReport) {
        Intrinsics.checkParameterIsNotNull((Object)meshScanReport, (String)"meshScanReport");
        return this.notifyOnMainThread(this.executeInBackground(this.restApiManagement.sendMeshScanReport(meshScanReport)));
    }

    private final Observable<MeshId> getMeshIdForDevice(CloudDeviceId deviceId) {
        Observable<MeshId> observable = this.restApiManagement.getDeviceMeshId(deviceId.getId());
        return observable;
    }

    private final Observable<MeshId> completeIfThereIsNoMeshConfigured(@NotNull Observable<MeshId> $receiver) {
        Observable observable = $receiver.flatMapMaybe((Function)completeIfThereIsNoMeshConfigured.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMapMaybe { mesh\u2026ter.onSuccess(meshId) } }");
        return observable;
    }

    private final Observable<CloudMeshMessage> mapToMeshMessage(@NotNull Observable<MeshId> $receiver) {
        Observable observable = $receiver.flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ EstimoteManagementCloud this$0;

            public final Observable<CloudMeshMessage> apply(@NotNull MeshId meshId) {
                Intrinsics.checkParameterIsNotNull((Object)meshId, (String)"meshId");
                ManagementCloudRestApi managementCloudRestApi = EstimoteManagementCloud.access$getRestApiManagement$p(this.this$0);
                Long l = meshId.getMeshId();
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                return managementCloudRestApi.getMeshMessage(l).map((Function)new Function<T, R>(meshId){
                    final /* synthetic */ MeshId $meshId;

                    @NotNull
                    public final CloudMeshMessage apply(@NotNull CloudMeshMessageBody it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Long l = this.$meshId.getMeshId();
                        if (l == null) {
                            Intrinsics.throwNpe();
                        }
                        return new CloudMeshMessage(l.longValue(), it.getData(), it.getSettingsVersion());
                    }
                    {
                        this.$meshId = meshId;
                    }
                });
            }
            {
                this.this$0 = estimoteManagementCloud;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMap { meshId  -\u2026, it.settingsVersion) } }");
        return observable;
    }

    private final Observable<CloudMeshMessage> completeIfThereIsNoMessageForDevice(@NotNull Observable<CloudMeshMessage> $receiver) {
        Observable observable = $receiver.flatMapMaybe((Function)completeIfThereIsNoMessageForDevice.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMapMaybe { mess\u2026er.onSuccess(message) } }");
        return observable;
    }

    private final <T> Observable<T> executeInBackground(@NotNull Observable<T> $receiver) {
        Observable observable = $receiver.subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.subscribeOn(Schedulers.io())");
        return observable;
    }

    private final Completable executeInBackground(@NotNull Completable $receiver) {
        Completable completable = $receiver.subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.subscribeOn(Schedulers.io())");
        return completable;
    }

    private final <T> Observable<T> notifyOnMainThread(@NotNull Observable<T> $receiver) {
        Observable observable = $receiver.observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.observeOn(AndroidSchedulers.mainThread())");
        return observable;
    }

    private final Completable notifyOnMainThread(@NotNull Completable $receiver) {
        Completable completable = $receiver.observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.observeOn(AndroidSchedulers.mainThread())");
        return completable;
    }

    @NotNull
    public final String toHexString(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String result = "";
        byte[] $receiver$iv = $receiver;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte it;
            byte octet = it = (element$iv = $receiver$iv[i]);
            int firstIndex = (octet & 0xF0) >>> 4;
            int secondIndex = octet & 0xF;
            result = result + "" + this.HEX_CHARS[firstIndex] + "" + this.HEX_CHARS[secondIndex];
        }
        return result;
    }

    public EstimoteManagementCloud(@NotNull ManagementCloudRestApi restApiManagement) {
        Intrinsics.checkParameterIsNotNull((Object)restApiManagement, (String)"restApiManagement");
        this.restApiManagement = restApiManagement;
        String string = "0123456789abcdef";
        EstimoteManagementCloud estimoteManagementCloud = this;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        estimoteManagementCloud.HEX_CHARS = cArray2;
    }

    @NotNull
    public static final /* synthetic */ ManagementCloudRestApi access$getRestApiManagement$p(EstimoteManagementCloud $this) {
        return $this.restApiManagement;
    }
}

