package com.estimote.cloud_plugin.proximity.model

import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachment
import com.google.gson.JsonObject

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteProximityAttachment(private val deviceId: String?,
                                  private val json: JsonObject?): ProximityAttachment {

    override fun getDeviceId() = deviceId ?: ""

    override fun getKeys() = json?.entrySet()?.map { it.key } ?: emptyList()

    override fun hasPair(key: String, value: String?): Boolean {
        return if (value != null) {
            hasKeyAndValue(key, value)
        } else hasKey(key)
    }

    override fun hasAttachment(): Boolean = json != null

    private fun hasKey(key: String) = json?.has(key) ?: false

    private fun hasKeyAndValue(key: String, value: String) = json?.get(key)?.asString.equals(value)
}