package com.estimote.cloud_plugin.proximity

import android.content.Context
import com.estimote.cloud_plugin.CloudManagerConfiguration
import com.estimote.cloud_plugin.proximity.dagger.DaggerProximityCloudComponent
import com.estimote.cloud_plugin.proximity.dagger.ProximityCloudModule
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.proximity.ProximityCloud
import javax.inject.Inject

class EstimoteProximityCloudFactory(applicationContext: Context,
                                    cloudConfiguration: CloudManagerConfiguration,
                                    sdkInfo: CloudSdkInfo,
                                    cloudCredentials: CloudCredentials) {
    @Inject internal lateinit var proximityCloud: ProximityCloud

    init {
        DaggerProximityCloudComponent.builder()
                .proximityCloudModule(ProximityCloudModule(applicationContext, cloudConfiguration.cloudEndpoint, sdkInfo, cloudCredentials))
                .build().inject(this)
    }

    fun create(): ProximityCloud = proximityCloud
}