package com.estimote.cloud_plugin.management.internal.rest.gson

import com.estimote.cloud_plugin.management.internal.dagger.model.MeshId
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import java.lang.reflect.Type

internal class MeshIdDeserializer: JsonDeserializer<MeshId> {

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): MeshId {
        return MeshId(json?.asJsonObject?.getData()?.getSettings()?.getAdvertisers()?.getMeshData()?.getMeshId())
    }

    private fun JsonObject.getData(): JsonObject? = this.nullableElement("data")?.asJsonObject

    private fun JsonObject.getSettings(): JsonObject? = this.nullableElement("settings")?.asJsonObject

    private fun JsonObject.getAdvertisers(): JsonObject? = this.nullableElement("advertisers")?.asJsonObject

    private fun JsonObject.getMeshData(): JsonObject? = this.nullableElement("mesh")?.asJsonArray?.get(0)?.asJsonObject

    private fun JsonObject.getMeshId(): Long? = this.nullableElement("mesh_identifier")?.asLong

    private fun JsonObject.nullableElement(elementName: String): JsonElement? {
        val element = this.get(elementName)
        return if(element == null || element.isJsonNull) null else element
    }
}