package com.estimote.cloud_plugin.common

import com.estimote.cloud_plugin.internal.rest.gson.CloudMeshConfigsDeserializer
import com.estimote.cloud_plugin.management.internal.dagger.model.MeshId
import com.estimote.cloud_plugin.management.internal.rest.gson.*
import com.estimote.cloud_plugin.proximity.rest.gson.ProximityAttachmentDeserializer
import com.estimote.internal_plugins_api.cloud.management.CloudCommands
import com.estimote.internal_plugins_api.cloud.management.CloudMeshConfigs
import com.estimote.internal_plugins_api.cloud.management.ManagementCloud.RequestStatus
import com.estimote.internal_plugins_api.cloud.management.CloudMeshMessageBody
import com.estimote.internal_plugins_api.cloud.management.CloudMeshSettingsVersion
import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachment
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.reflect.TypeToken
import javax.inject.Inject


internal class GsonFactory @Inject constructor() {
    fun createGson(): Gson {
        return GsonBuilder()
                .registerTypeAdapter(object : TypeToken<CloudMeshMessageBody>() {}.type, CloudMessageDeserializer())
                .registerTypeAdapter(object : TypeToken<MeshId>() {}.type, MeshIdDeserializer())
                .registerTypeAdapter(object : TypeToken<CloudCommands>() {}.type, CloudCommandsDeserializer())
                .registerTypeAdapter(object : TypeToken<RequestStatus>() {}.type, RequestStatusDeserializer())
                .registerTypeAdapter(object : TypeToken<CloudMeshConfigs>() {}.type, CloudMeshConfigsDeserializer())
                .registerTypeAdapter(object : TypeToken<CloudMeshSettingsVersion>() {}.type, CloudMeshSettingsVersionDeserializer())
                .registerTypeAdapter(object : TypeToken<ProximityAttachment>() {}.type, ProximityAttachmentDeserializer())
                .enableComplexMapKeySerialization()
                .serializeNulls()
                .setPrettyPrinting()
                .create()
    }
}
