/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.common;

import com.estimote.cloud_plugin.common.AuthorizationHeaderInterceptor;
import com.estimote.cloud_plugin.common.ContentTypeHeaderInterceptor;
import com.estimote.cloud_plugin.common.UserAgentHeaderInterceptor;
import com.google.gson.Gson;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/estimote/cloud_plugin/common/CloudApiFactory;", "", "gson", "Lcom/google/gson/Gson;", "contentTypeHeader", "Lcom/estimote/cloud_plugin/common/ContentTypeHeaderInterceptor;", "userAgentHeader", "Lcom/estimote/cloud_plugin/common/UserAgentHeaderInterceptor;", "authorizationHeader", "Lcom/estimote/cloud_plugin/common/AuthorizationHeaderInterceptor;", "(Lcom/google/gson/Gson;Lcom/estimote/cloud_plugin/common/ContentTypeHeaderInterceptor;Lcom/estimote/cloud_plugin/common/UserAgentHeaderInterceptor;Lcom/estimote/cloud_plugin/common/AuthorizationHeaderInterceptor;)V", "createRestApiFactory", "T", "endpoint", "", "endpointClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getHttpClient", "Lokhttp3/OkHttpClient;", "interceptors", "", "Lokhttp3/Interceptor;", "([Lokhttp3/Interceptor;)Lokhttp3/OkHttpClient;", "cloud-plugin_release"})
public final class CloudApiFactory {
    private final Gson gson;
    private final ContentTypeHeaderInterceptor contentTypeHeader;
    private final UserAgentHeaderInterceptor userAgentHeader;
    private final AuthorizationHeaderInterceptor authorizationHeader;

    public final <T> T createRestApiFactory(@NotNull String endpoint, @NotNull Class<T> endpointClass) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull(endpointClass, (String)"endpointClass");
        return (T)new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.getHttpClient(this.contentTypeHeader, this.userAgentHeader, this.authorizationHeader)).build().create(endpointClass);
    }

    private final OkHttpClient getHttpClient(Interceptor ... interceptors) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        Object[] $receiver$iv = interceptors;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            Interceptor it = (Interceptor)element$iv;
            clientBuilder.addInterceptor(it);
        }
        OkHttpClient okHttpClient = clientBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"clientBuilder.build()");
        return okHttpClient;
    }

    @Inject
    public CloudApiFactory(@NotNull Gson gson, @NotNull ContentTypeHeaderInterceptor contentTypeHeader, @NotNull UserAgentHeaderInterceptor userAgentHeader, @NotNull AuthorizationHeaderInterceptor authorizationHeader) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)contentTypeHeader, (String)"contentTypeHeader");
        Intrinsics.checkParameterIsNotNull((Object)userAgentHeader, (String)"userAgentHeader");
        Intrinsics.checkParameterIsNotNull((Object)authorizationHeader, (String)"authorizationHeader");
        this.gson = gson;
        this.contentTypeHeader = contentTypeHeader;
        this.userAgentHeader = userAgentHeader;
        this.authorizationHeader = authorizationHeader;
    }
}

