package com.estimote.cloud_plugin.proximity.dagger

import android.content.Context
import com.estimote.cloud_plugin.common.*
import com.estimote.cloud_plugin.proximity.EstimoteProximityCloud
import com.estimote.cloud_plugin.proximity.rest.ProximityCloudRestApi
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.proximity.ProximityCloud
import com.google.gson.Gson
import dagger.Module
import dagger.Provides
import java.nio.charset.Charset
import java.nio.charset.CharsetEncoder

@Module
internal class ProximityCloudModule(private val appContext: Context,
                                    private val cloudEndpoint: String,
                                    private val sdkInfo: CloudSdkInfo,
                                    private val cloudCredentials: CloudCredentials) {

    @Provides @ProximityCloudScope internal fun provideApplicationContext(): Context = appContext

    @Provides @ProximityCloudScope internal fun provideCloudCredentials() = cloudCredentials

    @Provides @ProximityCloudScope internal fun provideSharedPreferencesProvider(context: Context): SharedPreferencesProvider = SharedPreferencesProvider(context)

    @Provides @ProximityCloudScope internal fun provideGson(gsonFactory: GsonFactory): Gson = gsonFactory.createGson()

    @Provides @ProximityCloudScope internal fun provideUserAgentProvider(asciiEncoder: CharsetEncoder) = CloudUserAgentProvider(appContext, sdkInfo, asciiEncoder)

    @Provides @ProximityCloudScope internal fun provideAsciiEncoder() = Charset.forName("ASCII").newEncoder()

    @Provides @ProximityCloudScope internal fun provideCloudRestApi(cloudApiFactory: CloudApiFactory): ProximityCloudRestApi = cloudApiFactory.createRestApiFactory(cloudEndpoint, ProximityCloudRestApi::class.java)

    @Provides @ProximityCloudScope internal fun provideProximityCloud(proximityCloudRestApi: ProximityCloudRestApi): ProximityCloud = EstimoteProximityCloud(proximityCloudRestApi)
}