package com.estimote.cloud_plugin.proximity

import android.util.Log
import com.estimote.cloud_plugin.proximity.rest.ProximityCloudRestApi
import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachment
import com.estimote.internal_plugins_api.cloud.proximity.ProximityCloud
import io.reactivex.Single
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

internal class EstimoteProximityCloud(private val proximityCloudRestApi: ProximityCloudRestApi): ProximityCloud {

    override fun getDeviceIdToProximityAttachmentMapping(): Single<Map<String, ProximityAttachment>> {
        return proximityCloudRestApi.getProximityAttachmentsForAllDevices()
                .filterInvalidIdentifiers()
                .filterNullAttachments()
                .proximityAttachmentsToMap()
                .executeInBackground()
                .notifyOnMainThread()
    }

    private fun Single<List<ProximityAttachment>>.proximityAttachmentsToMap() = map { it.associateBy ({it.getDeviceId()}, {it})  }

    private fun Single<List<ProximityAttachment>>.filterInvalidIdentifiers() = map { it.filter { it.getDeviceId().isNotEmpty() } }

    private fun Single<List<ProximityAttachment>>.filterNullAttachments() = map { it.filter { it.hasAttachment() } }

    private fun <T> Single<T>.executeInBackground(): Single<T> =
            this.subscribeOn(Schedulers.io())

    private fun <T> Single<T>.notifyOnMainThread(): Single<T> =
            this.observeOn(AndroidSchedulers.mainThread())
}