package com.estimote.cloud_plugin.common

import com.estimote.internal_plugins_api.cloud.CloudCredentials
import okio.ByteString

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteCloudCredentials(appId: String,
                               appToken: String) : CloudCredentials {

    override val basicAuthorisation: String by lazy { ByteString.encodeUtf8(appId + ":" + appToken).base64()}

}
