package com.estimote.cloud_plugin.proximity.rest.gson

import com.estimote.cloud_plugin.proximity.model.EstimoteProximityAttachment
import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachment
import com.google.gson.*
import java.lang.reflect.Type

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class ProximityAttachmentDeserializer : JsonDeserializer<ProximityAttachment> {

    private val jsonParser = JsonParser()

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): ProximityAttachment =
            EstimoteProximityAttachment(json?.getDeviceId(), json?.asJsonObject?.getShadow()?.getTags()?.getAttachment())

    private fun JsonObject.getShadow(): JsonObject? = this.nullableElement("shadow")?.asJsonObject
    private fun JsonObject.getTags(): JsonArray? = this.nullableElement("tags")?.asJsonArray
    private fun JsonElement.getDeviceId(): String? = this.asJsonObject.nullableElement("identifier")?.asString

    private fun JsonObject.nullableElement(elementName: String): JsonElement? {
        val element = this.get(elementName)
        return if (element == null || element.isJsonNull) null else element
    }

    private fun JsonArray.getAttachment(): JsonObject? {
        forEach {
            try {
                val parsedTag = jsonParser.parse(it.asString).asJsonObject
                if (parsedTag.has("attachment")) return parsedTag.getAsJsonObject("attachment")
            } catch (e: Exception) {
                /* do nothing */
            }
        }
        return null
    }
}