package com.estimote.cloud_plugin.proximity.model

import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachment
import com.google.gson.JsonObject

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteProximityAttachment(private val deviceId: String?,
                                  private val json: JsonObject?): ProximityAttachment {

    override fun getDeviceId() = deviceId ?: ""

    override fun getKeys() = json?.entrySet()?.map { it.key } ?: emptyList()

    override fun hasKey(key: String) = json?.has(key) ?: false

    override fun hasAttachment(): Boolean = json != null
}