package com.estimote.cloud_plugin.management.internal.dagger

import android.content.Context
import com.estimote.cloud_plugin.common.GsonFactory
import com.estimote.cloud_plugin.common.CloudApiFactory
import com.estimote.cloud_plugin.common.CloudUserAgentProvider
import com.estimote.cloud_plugin.common.SharedPreferencesProvider
import com.estimote.cloud_plugin.management.internal.EstimoteManagementCloud
import com.estimote.cloud_plugin.management.internal.rest.*
import com.estimote.cloud_plugin.proximity.dagger.ProximityCloudScope
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.management.ManagementCloud
import com.google.gson.Gson
import dagger.Module
import dagger.Provides
import java.nio.charset.Charset
import java.nio.charset.CharsetEncoder
import javax.inject.Singleton

@Module
internal class ManagementCloudModule(private val appContext: Context,
                                     private val cloudEndpoint: String,
                                     private val cloudSdkInfo: CloudSdkInfo,
                                     private val cloudCredentials: CloudCredentials) {

    @Provides @ManagementCloudScope internal fun provideApplicationContext(): Context = appContext

    @Provides @ManagementCloudScope internal fun provideCloudCredentials() = cloudCredentials

    @Provides @ManagementCloudScope internal fun provideSharedPreferencesProvider(context: Context): SharedPreferencesProvider = SharedPreferencesProvider(context)

    @Provides @ManagementCloudScope internal fun provideGson(gsonFactory: GsonFactory): Gson = gsonFactory.createGson()

    @Provides @ManagementCloudScope internal fun provideUserAgentProvider(asciiEncoder: CharsetEncoder) = CloudUserAgentProvider(appContext, cloudSdkInfo, asciiEncoder)

    @Provides @ManagementCloudScope internal fun provideAsciiEncoder() = Charset.forName("ASCII").newEncoder()

    @Provides @ManagementCloudScope internal fun provideCloudRestApi(cloudApiFactory: CloudApiFactory): ManagementCloudRestApi = cloudApiFactory.createRestApiFactory(cloudEndpoint, ManagementCloudRestApi::class.java)

    @Provides @ManagementCloudScope internal fun provideCloudManager(restApiManagement: ManagementCloudRestApi): ManagementCloud = EstimoteManagementCloud(restApiManagement)
}