package com.estimote.cloud_plugin.common

import android.content.Context
import android.content.SharedPreferences

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class SharedPreferencesProvider(private val context: Context) {

    private val SHARED_PREFERENCES_NAME = "estimote"
    private val AUTH_COOKIE_KEY = "auth_cookie"

    fun get(): SharedPreferences =
            context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)

    fun getAuthCookie(): String = get().getString(AUTH_COOKIE_KEY, "-")

    fun hasAuthCookie() = get().contains(AUTH_COOKIE_KEY)

    fun setAuthCookie(cookie: String) = get().edit().putString(AUTH_COOKIE_KEY, cookie).apply()

}