/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.management.internal.rest.gson;

import com.estimote.internal_plugins_api.cloud.management.CloudMeshMessageBody;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000f*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/estimote/cloud_plugin/management/internal/rest/gson/CloudMessageDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/estimote/internal_plugins_api/cloud/management/CloudMeshMessageBody;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "getMeshMessageBufferBytes", "", "kotlin.jvm.PlatformType", "messageBufferString", "", "getMeshMessageDataStringProperty", "propertyName", "getSettingsVersionBytes", "", "settingsVersionString", "getData", "Lcom/google/gson/JsonObject;", "getProperty", "cloud-plugin_release"})
public final class CloudMessageDeserializer
implements JsonDeserializer<CloudMeshMessageBody> {
    @NotNull
    public CloudMeshMessageBody deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        byte[] byArray = this.getMeshMessageBufferBytes(this.getMeshMessageDataStringProperty("message_buffer", json));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"getMeshMessageBufferByte\u2026(\"message_buffer\", json))");
        return new CloudMeshMessageBody(byArray, this.getSettingsVersionBytes(this.getMeshMessageDataStringProperty("settings_version", json)));
    }

    private final byte[] getMeshMessageBufferBytes(String messageBufferString) {
        return ByteString.decodeHex((String)messageBufferString).toByteArray();
    }

    private final long getSettingsVersionBytes(String settingsVersionString) {
        Long l = StringsKt.toLongOrNull((String)settingsVersionString);
        if (l == null) {
            throw (Throwable)new InvalidObjectException("Unable to get settings_version value form received json");
        }
        return l;
    }

    private final String getMeshMessageDataStringProperty(String propertyName, JsonElement json) {
        Object object = json;
        if (object == null || (object = object.getAsJsonObject()) == null || (object = this.getData((JsonObject)object)) == null || (object = this.getProperty((JsonObject)object, propertyName)) == null) {
            object = "";
        }
        return object;
    }

    private final JsonObject getData(@NotNull JsonObject $receiver) {
        JsonElement jsonElement = $receiver.get("data");
        return jsonElement != null ? jsonElement.getAsJsonObject() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getProperty(@NotNull JsonObject $receiver, String propertyName) {
        if ($receiver.get(propertyName) == null) return null;
        JsonElement jsonElement = $receiver.get(propertyName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"this.get(propertyName)");
        if (jsonElement.isJsonNull()) {
            return null;
        }
        JsonElement jsonElement2 = $receiver.get(propertyName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"this.get(propertyName)");
        String string = jsonElement2.getAsString();
        return string;
    }
}

