/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.common;

import com.estimote.cloud_plugin.common.AuthorizationHeaderInterceptor;
import com.estimote.cloud_plugin.common.ContentTypeHeaderInterceptor;
import com.estimote.cloud_plugin.common.NoCookieAuthorizationHeaderInterceptor;
import com.estimote.cloud_plugin.common.UserAgentHeaderInterceptor;
import com.google.gson.Gson;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ'\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0014\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u00a2\u0006\u0002\u0010\u0013J!\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/estimote/cloud_plugin/common/CloudApiFactory;", "", "gson", "Lcom/google/gson/Gson;", "contentTypeHeader", "Lcom/estimote/cloud_plugin/common/ContentTypeHeaderInterceptor;", "userAgentHeader", "Lcom/estimote/cloud_plugin/common/UserAgentHeaderInterceptor;", "authorizationHeader", "Lcom/estimote/cloud_plugin/common/AuthorizationHeaderInterceptor;", "noCookieAuthorizationHeader", "Lcom/estimote/cloud_plugin/common/NoCookieAuthorizationHeaderInterceptor;", "(Lcom/google/gson/Gson;Lcom/estimote/cloud_plugin/common/ContentTypeHeaderInterceptor;Lcom/estimote/cloud_plugin/common/UserAgentHeaderInterceptor;Lcom/estimote/cloud_plugin/common/AuthorizationHeaderInterceptor;Lcom/estimote/cloud_plugin/common/NoCookieAuthorizationHeaderInterceptor;)V", "createRestApiFactory", "T", "endpoint", "", "endpointClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "createRestApiFactoryWithNoCookieAuthorization", "getHttpClient", "Lokhttp3/OkHttpClient;", "interceptors", "", "Lokhttp3/Interceptor;", "([Lokhttp3/Interceptor;)Lokhttp3/OkHttpClient;", "cloud-plugin_release"})
public final class CloudApiFactory {
    private final Gson gson;
    private final ContentTypeHeaderInterceptor contentTypeHeader;
    private final UserAgentHeaderInterceptor userAgentHeader;
    private final AuthorizationHeaderInterceptor authorizationHeader;
    private final NoCookieAuthorizationHeaderInterceptor noCookieAuthorizationHeader;

    public final <T> T createRestApiFactory(@NotNull String endpoint, @NotNull Class<T> endpointClass) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull(endpointClass, (String)"endpointClass");
        return (T)new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.getHttpClient(this.contentTypeHeader, this.userAgentHeader, this.authorizationHeader)).build().create(endpointClass);
    }

    public final <T> T createRestApiFactoryWithNoCookieAuthorization(@NotNull String endpoint, @NotNull Class<T> endpointClass) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull(endpointClass, (String)"endpointClass");
        return (T)new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.getHttpClient(this.contentTypeHeader, this.userAgentHeader, this.noCookieAuthorizationHeader)).build().create(endpointClass);
    }

    private final OkHttpClient getHttpClient(Interceptor ... interceptors) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        for (Object element$iv : (Object[])interceptors) {
            Interceptor it = (Interceptor)element$iv;
            clientBuilder.addInterceptor(it);
        }
        OkHttpClient okHttpClient = clientBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"clientBuilder.build()");
        return okHttpClient;
    }

    @Inject
    public CloudApiFactory(@NotNull Gson gson, @NotNull ContentTypeHeaderInterceptor contentTypeHeader, @NotNull UserAgentHeaderInterceptor userAgentHeader, @NotNull AuthorizationHeaderInterceptor authorizationHeader, @NotNull NoCookieAuthorizationHeaderInterceptor noCookieAuthorizationHeader) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)contentTypeHeader, (String)"contentTypeHeader");
        Intrinsics.checkParameterIsNotNull((Object)userAgentHeader, (String)"userAgentHeader");
        Intrinsics.checkParameterIsNotNull((Object)authorizationHeader, (String)"authorizationHeader");
        Intrinsics.checkParameterIsNotNull((Object)noCookieAuthorizationHeader, (String)"noCookieAuthorizationHeader");
        this.gson = gson;
        this.contentTypeHeader = contentTypeHeader;
        this.userAgentHeader = userAgentHeader;
        this.authorizationHeader = authorizationHeader;
        this.noCookieAuthorizationHeader = noCookieAuthorizationHeader;
    }
}

