/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.common;

import com.estimote.cloud_plugin.common.SharedPreferencesProvider;
import com.estimote.internal_plugins_api.cloud.CloudCredentials;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/estimote/cloud_plugin/common/AuthorizationHeaderInterceptor;", "Lokhttp3/Interceptor;", "sharedPreferencesProvider", "Lcom/estimote/cloud_plugin/common/SharedPreferencesProvider;", "cloudCredentials", "Lcom/estimote/internal_plugins_api/cloud/CloudCredentials;", "(Lcom/estimote/cloud_plugin/common/SharedPreferencesProvider;Lcom/estimote/internal_plugins_api/cloud/CloudCredentials;)V", "buildBasicAuthHeader", "Lokhttp3/Request;", "kotlin.jvm.PlatformType", "chain", "Lokhttp3/Interceptor$Chain;", "buildCookieHeader", "intercept", "Lokhttp3/Response;", "cloud-plugin_release"})
public final class AuthorizationHeaderInterceptor
implements Interceptor {
    private final SharedPreferencesProvider sharedPreferencesProvider;
    private final CloudCredentials cloudCredentials;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        if (this.sharedPreferencesProvider.hasAuthCookie()) {
            Response response2 = chain.proceed(this.buildCookieHeader(chain));
            response = response2;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(buildCookieHeader(chain))");
        } else {
            Response response3 = chain.proceed(this.buildBasicAuthHeader(chain));
            response = response3;
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"chain.proceed(buildBasicAuthHeader(chain))");
        }
        return response;
    }

    private final Request buildCookieHeader(Interceptor.Chain chain) {
        return chain.request().newBuilder().addHeader("Cookie", this.sharedPreferencesProvider.getAuthCookie()).build();
    }

    private final Request buildBasicAuthHeader(Interceptor.Chain chain) {
        return chain.request().newBuilder().addHeader("Authorization", "Basic " + this.cloudCredentials.getBasicAuthorisation()).build();
    }

    @Inject
    public AuthorizationHeaderInterceptor(@NotNull SharedPreferencesProvider sharedPreferencesProvider, @NotNull CloudCredentials cloudCredentials) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferencesProvider, (String)"sharedPreferencesProvider");
        Intrinsics.checkParameterIsNotNull((Object)cloudCredentials, (String)"cloudCredentials");
        this.sharedPreferencesProvider = sharedPreferencesProvider;
        this.cloudCredentials = cloudCredentials;
    }
}

