package com.estimote.cloud_plugin.secure

import android.content.Context
import com.estimote.cloud_plugin.secure.dagger.DaggerSecureCloudComponent
import com.estimote.cloud_plugin.secure.dagger.SecureCloudModule
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudEndpointConfiguration
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.secure.ResolvedEstimoteLocation
import com.estimote.internal_plugins_api.cloud.secure.SecureCloud
import javax.inject.Inject

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteSecureCloudFactory(applicationContext: Context,
                                 cloudConfiguration: CloudEndpointConfiguration,
                                 sdkInfo: CloudSdkInfo,
                                 cloudCredentials: CloudCredentials) {

    @Inject
    internal lateinit var estimoteLocationSecureCloud: SecureCloud<ResolvedEstimoteLocation>

    init {
        DaggerSecureCloudComponent.builder()
                .secureCloudModule(SecureCloudModule(applicationContext, cloudConfiguration.cloudEndpoint, sdkInfo, cloudCredentials))
                .build().inject(this)
    }

    fun create(): SecureCloud<ResolvedEstimoteLocation> = estimoteLocationSecureCloud

}