package com.estimote.cloud_plugin.secure

import com.estimote.cloud_plugin.secure.resolvers.EstimoteLocationSecurePacketResolver
import com.estimote.internal_plugins_api.cloud.secure.ResolvedEstimoteLocation
import com.estimote.internal_plugins_api.cloud.secure.SecureCloud
import com.estimote.internal_plugins_api.scanning.EstimoteLocation
import com.estimote.internal_plugins_api.secure.SecurePacketResolver
import java.util.concurrent.TimeUnit

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteLocationSecureResolverBuilder(private val secureCloud: SecureCloud<ResolvedEstimoteLocation>) {

    private var payloadFixedTimeoutInterval: Long = 300L
    private var payloadFixedTimeoutUnit: TimeUnit = TimeUnit.SECONDS
    private var payloadTimeoutInterval: Long = 30L
    private var payloadTimeoutUnit: TimeUnit = TimeUnit.SECONDS

    fun withPayloadFixedTimeout(payloadFixedTimeoutInterval: Long, payloadFixedTimeoutUnit: TimeUnit) = apply {
        this.payloadFixedTimeoutInterval = payloadFixedTimeoutInterval
        this.payloadFixedTimeoutUnit = payloadFixedTimeoutUnit
    }

    fun withPayloadTimeout(payloadTimeoutInterval: Long, payloadTimeoutUnit: TimeUnit) = apply {
        this.payloadTimeoutInterval = payloadTimeoutInterval
        this.payloadTimeoutUnit = payloadTimeoutUnit
    }

    fun build(): SecurePacketResolver<EstimoteLocation> = EstimoteLocationSecurePacketResolver(
            secureCloud,
            payloadFixedTimeoutInterval,
            payloadFixedTimeoutUnit,
            payloadTimeoutInterval,
            payloadTimeoutUnit)

}