package com.estimote.cloud_plugin.proximity.rest.gson

import com.estimote.cloud_plugin.proximity.model.EstimoteProximityAttachmentModel
import com.estimote.cloud_plugin.proximity.model.ProximityAttachmentResponse
import com.estimote.internal_plugins_api.cloud.proximity.ProximityAttachmentModel
import com.google.gson.*
import java.lang.reflect.Type

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class ProximityAttachmentResponseDeserializer : JsonDeserializer<ProximityAttachmentResponse> {
    

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?) =
            ProximityAttachmentResponse(json?.getData()?.getAttachment() ?: listOf<ProximityAttachmentModel>())

    private fun JsonElement.getData(): JsonArray? = this.asJsonObject.nullableElement("data")?.asJsonArray

    private fun JsonElement.getDeviceId(): String? = this.asJsonObject.nullableElement("identifier")?.asString

    private fun JsonObject.getPayload(): Map<String, String> {
        val entries = this.nullableElement("payload")?.asJsonObject?.entrySet()
        return entries?.associate { it.key to it.value.asString } ?: emptyMap()
    }

    private fun JsonObject.nullableElement(elementName: String): JsonElement? {
        val element = this.get(elementName)
        return if (element == null || element.isJsonNull) null else element
    }

    private fun JsonArray.getAttachment() = map { EstimoteProximityAttachmentModel(it.getDeviceId(), it.asJsonObject.getPayload()) }
}