package com.estimote.cloud_plugin.management.internal.rest.gson

import com.estimote.internal_plugins_api.cloud.management.CloudMeshSettingsVersion
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import java.lang.reflect.Type

internal class CloudMeshSettingsVersionDeserializer: JsonDeserializer<CloudMeshSettingsVersion> {
    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): CloudMeshSettingsVersion {
        return CloudMeshSettingsVersion(json?.asJsonObject?.getAsJsonObject("data")?.getAsJsonPrimitive("settings_version")?.asInt ?: 0)
    }
}