package com.estimote.cloud_plugin.management

import android.content.Context
import com.estimote.cloud_plugin.management.internal.dagger.DaggerManagementCloudComponent
import com.estimote.cloud_plugin.management.internal.dagger.ManagementCloudModule
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudEndpointConfiguration
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.management.ManagementCloud
import javax.inject.Inject

class ManagementCloudFactory(applicationContext: Context,
                             cloudManagerConfiguration: CloudEndpointConfiguration,
                             cloudSdkInfo: CloudSdkInfo,
                             cloudCredentials: CloudCredentials) {
    @Inject internal lateinit var managementCloud: ManagementCloud

    init { DaggerManagementCloudComponent.builder().managementCloudModule(ManagementCloudModule(applicationContext, cloudManagerConfiguration.cloudEndpoint, cloudSdkInfo, cloudCredentials)).build().inject(this) }

    fun create(): ManagementCloud = managementCloud
}
