package com.estimote.cloud_plugin.common

import com.estimote.internal_plugins_api.cloud.CloudCredentials
import okhttp3.Interceptor
import okhttp3.Response
import javax.inject.Inject

internal class ContentTypeHeaderInterceptor @Inject constructor() : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response = chain.proceed(buildHeader(chain))

    private fun buildHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Accept", "application/json").build()
}

internal class UserAgentHeaderInterceptor @Inject constructor(private val userAgentProvider: CloudUserAgentProvider) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response = chain.proceed(buildHeader(chain))

    private fun buildHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("User-Agent", userAgentProvider.userAgent).build()
}

internal class AuthorizationHeaderInterceptor @Inject constructor(private val sharedPreferencesProvider: SharedPreferencesProvider,
                                                                  private val cloudCredentials: CloudCredentials) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        return if (sharedPreferencesProvider.hasAuthCookie()) chain.proceed(buildCookieHeader(chain))
        else chain.proceed(buildBasicAuthHeader(chain))
    }

    private fun buildCookieHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Cookie", sharedPreferencesProvider.getAuthCookie()).build()

    private fun buildBasicAuthHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Authorization", "Basic " + cloudCredentials.basicAuthorisation).build()
}

internal class NoCookieAuthorizationHeaderInterceptor @Inject constructor(private val cloudCredentials: CloudCredentials) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response = chain.proceed(buildBasicAuthHeader(chain))

    private fun buildBasicAuthHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Authorization", "Basic " + cloudCredentials.basicAuthorisation).build()
}