package com.estimote.cloud_plugin.common

import android.content.Context
import android.provider.Settings
import com.estimote.internal_plugins_api.common.DeviceGeneralInfo
import com.estimote.internal_plugins_api.common.DeviceGeneralInfoProvider

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class CommonDeviceGeneralInfoProvider : DeviceGeneralInfoProvider {

    private val PLATFORM_NAME = "Android"

    override fun provideGeneralInfo(context: Context): DeviceGeneralInfo =
            DeviceGeneralInfo(
                    context.packageName,
                    getDeviceId(context),
                    getDeviceModel(),
                    PLATFORM_NAME)


    private fun getDeviceId(context: Context): String {
        // TODO: Think about using InstanceID here.
        return Settings.Secure.getString(context.contentResolver, Settings.Secure.ANDROID_ID)
    }

    private fun getDeviceModel(): String {
        return if (android.os.Build.MODEL.startsWith(android.os.Build.MANUFACTURER)) {
            android.os.Build.MODEL
        } else {
            android.os.Build.MANUFACTURER + " " + android.os.Build.MODEL
        }
    }
}