package com.estimote.cloud_plugin.common

import com.google.gson.Gson
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import javax.inject.Inject

internal class CloudApiFactory @Inject constructor(
        private val gson: Gson,
        private val contentTypeHeader: ContentTypeHeaderInterceptor,
        private val userAgentHeader: UserAgentHeaderInterceptor,
        private val authorizationHeader: AuthorizationHeaderInterceptor,
        private val noCookieAuthorizationHeader: NoCookieAuthorizationHeaderInterceptor) {

    fun <T> createRestApiFactory(endpoint: String, endpointClass: Class<T>): T {
        return Retrofit.Builder()
                .baseUrl(endpoint)
                .addConverterFactory(GsonConverterFactory.create(gson))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .client(getHttpClient(contentTypeHeader, userAgentHeader, authorizationHeader))
                .build()
                .create(endpointClass)
    }

    fun <T> createRestApiFactoryWithNoCookieAuthorization(endpoint: String, endpointClass: Class<T>): T {
        return Retrofit.Builder()
                .baseUrl(endpoint)
                .addConverterFactory(GsonConverterFactory.create(gson))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .client(getHttpClient(contentTypeHeader, userAgentHeader, noCookieAuthorizationHeader))
                .build()
                .create(endpointClass)
    }

    private fun getHttpClient(vararg interceptors: Interceptor): OkHttpClient {
        val clientBuilder = OkHttpClient().newBuilder()
        interceptors.forEach { clientBuilder.addInterceptor(it) }
        return clientBuilder.build()
    }
}