package com.estimote.cloud_plugin.analytics.rest

import com.estimote.cloud_plugin.analytics.model.CloudAnalyticsEventsBatch
import com.estimote.cloud_plugin.analytics.model.CloudTelemetryBatch
import com.estimote.cloud_plugin.analytics.model.CloudTelemetryModel
import io.reactivex.Completable
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal interface AnalyticsCloudRestApi {

    @POST("v3/analytics/track_events")
    fun postAnalyticsEvents(@Body events: CloudAnalyticsEventsBatch): Completable

    @GET("v2/devices/{id}/zones_bounds")
    fun getZonesBounds(@Path("id") id: String): Completable

    @POST("v3/telemetry")
    fun postTelemetry(@Body telemetry: CloudTelemetryBatch): Completable

}