package com.estimote.cloud_plugin.analytics.dagger

import android.content.Context
import com.estimote.cloud_plugin.analytics.EstimoteAnalyticsCloud
import com.estimote.cloud_plugin.analytics.rest.AnalyticsCloudRestApi
import com.estimote.cloud_plugin.common.*
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.analytics.AnalyticsCloud
import com.estimote.internal_plugins_api.common.DeviceGeneralInfo
import com.estimote.internal_plugins_api.common.DeviceGeneralInfoProvider
import com.google.gson.Gson
import dagger.Module
import dagger.Provides
import java.nio.charset.Charset
import java.nio.charset.CharsetEncoder

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@Module
@AnalyticsCloudScope
internal class AnalyticsCloudModule(private val appContext: Context,
                                    private val cloudEndpoint: String,
                                    private val sdkInfo: CloudSdkInfo,
                                    private val cloudCredentials: CloudCredentials) {

    @Provides @AnalyticsCloudScope internal fun provideCloudCredentials() = cloudCredentials

    @Provides @AnalyticsCloudScope internal fun provideSharedPreferencesProvider(): SharedPreferencesProvider = SharedPreferencesProvider(appContext)

    @Provides @AnalyticsCloudScope internal fun provideGson(gsonFactory: GsonFactory): Gson = gsonFactory.createGson()

    @Provides @AnalyticsCloudScope internal fun provideDeviceGeneralInfoProvider(): DeviceGeneralInfoProvider = CommonDeviceGeneralInfoProvider()

    @Provides @AnalyticsCloudScope internal fun provideDeviceGeneralInfo(generalInfoProvider: DeviceGeneralInfoProvider) = generalInfoProvider.provideGeneralInfo(appContext)

    @Provides @AnalyticsCloudScope internal fun provideUserAgentProvider(generalInfo: DeviceGeneralInfo) = CloudUserAgentProvider(sdkInfo, generalInfo)

    @Provides @AnalyticsCloudScope internal fun provideCloudRestApi(cloudApiFactory: CloudApiFactory): AnalyticsCloudRestApi = cloudApiFactory.createRestApiFactoryWithNoCookieAuthorization(cloudEndpoint, AnalyticsCloudRestApi::class.java)

    @Provides @AnalyticsCloudScope internal fun provideAnalyticsCloud(analyticsCloudRestApi: AnalyticsCloudRestApi): AnalyticsCloud = EstimoteAnalyticsCloud(analyticsCloudRestApi)
}