package com.estimote.cloud_plugin.analytics

import android.content.Context
import com.estimote.cloud_plugin.analytics.dagger.AnalyticsCloudModule
import com.estimote.cloud_plugin.analytics.dagger.DaggerAnalyticsCloudComponent
import com.estimote.internal_plugins_api.cloud.CloudCredentials
import com.estimote.internal_plugins_api.cloud.CloudEndpointConfiguration
import com.estimote.internal_plugins_api.cloud.CloudSdkInfo
import com.estimote.internal_plugins_api.cloud.analytics.AnalyticsCloud
import javax.inject.Inject

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteAnalyticsCloudFactory {

    @Inject internal lateinit var analyticsCloud: AnalyticsCloud

    fun create(applicationContext: Context,
               cloudConfiguration: CloudEndpointConfiguration,
               sdkInfo: CloudSdkInfo,
               cloudCredentials: CloudCredentials): AnalyticsCloud {
        DaggerAnalyticsCloudComponent.builder()
                .analyticsCloudModule(AnalyticsCloudModule(applicationContext, cloudConfiguration.cloudEndpoint, sdkInfo, cloudCredentials))
                .build().inject(this)
        return analyticsCloud
    }
}