/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.internal.rest;

import android.content.SharedPreferences;
import com.estimote.coresdk.common.config.EstimoteSDK;
import com.estimote.coresdk.repackaged.okio_v1_3_0.okio.ByteString;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/estimote/cloud_plugin/internal/rest/AuthorizationHeaderInterceptor;", "Lokhttp3/Interceptor;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "buildBasicAuthHeader", "Lokhttp3/Request;", "kotlin.jvm.PlatformType", "chain", "Lokhttp3/Interceptor$Chain;", "buildCookieHeader", "intercept", "Lokhttp3/Response;", "cloud-plugin_release"})
public final class AuthorizationHeaderInterceptor
implements Interceptor {
    private final SharedPreferences sharedPreferences;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        if (this.sharedPreferences.contains("auth_cookie")) {
            Response response2 = chain.proceed(this.buildCookieHeader(chain));
            response = response2;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(buildCookieHeader(chain))");
        } else {
            Response response3 = chain.proceed(this.buildBasicAuthHeader(chain));
            response = response3;
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"chain.proceed(buildBasicAuthHeader(chain))");
        }
        return response;
    }

    private final Request buildCookieHeader(Interceptor.Chain chain) {
        return chain.request().newBuilder().addHeader("Cookie", this.sharedPreferences.getString("auth_cookie", "-")).build();
    }

    private final Request buildBasicAuthHeader(Interceptor.Chain chain) {
        return chain.request().newBuilder().addHeader("Authorization", "Basic " + ByteString.encodeUtf8((String)(EstimoteSDK.getAppId() + ":" + EstimoteSDK.getAppToken())).base64()).build();
    }

    @Inject
    public AuthorizationHeaderInterceptor(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }
}

