/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.cloud_plugin.internal;

import com.estimote.cloud_plugin.internal.EstimoteCloudManager;
import com.estimote.cloud_plugin.internal.MeshSettingsVersionUpdateFactory;
import com.estimote.cloud_plugin.internal.dagger.model.MeshId;
import com.estimote.cloud_plugin.internal.rest.CloudRestApi;
import com.estimote.internal_plugins_api.cloud.CloudDeviceId;
import com.estimote.internal_plugins_api.cloud.CloudManager;
import com.estimote.internal_plugins_api.cloud.CloudMeshMessage;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\f\u0010\u0010\u001a\u00020\u000b*\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\b\u0012\u0004\u0012\u00020\u00120\u0006H\u0002J\f\u0010\u0013\u001a\u00020\u000b*\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/estimote/cloud_plugin/internal/EstimoteCloudManager;", "Lcom/estimote/internal_plugins_api/cloud/CloudManager;", "restApi", "Lcom/estimote/cloud_plugin/internal/rest/CloudRestApi;", "(Lcom/estimote/cloud_plugin/internal/rest/CloudRestApi;)V", "getMeshMessageForDevice", "Lio/reactivex/Observable;", "Lcom/estimote/internal_plugins_api/cloud/CloudMeshMessage;", "deviceId", "Lcom/estimote/internal_plugins_api/cloud/CloudDeviceId;", "updateSettingsVersion", "Lio/reactivex/Completable;", "", "settingsVersion", "", "completeIfThereIsNoMessageForDevice", "executeInBackground", "mapToMeshMessage", "Lcom/estimote/cloud_plugin/internal/dagger/model/MeshId;", "notifyOnMainThread", "cloud-plugin_release"})
public final class EstimoteCloudManager
implements CloudManager {
    private final CloudRestApi restApi;

    @NotNull
    public Observable<CloudMeshMessage> getMeshMessageForDevice(@NotNull CloudDeviceId deviceId) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        return this.notifyOnMainThread(this.executeInBackground(this.completeIfThereIsNoMessageForDevice(this.mapToMeshMessage(this.restApi.getDeviceMeshId(deviceId.getId())))));
    }

    @NotNull
    public Completable updateSettingsVersion(@NotNull String deviceId, long settingsVersion) {
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        return this.notifyOnMainThread(this.executeInBackground(this.restApi.updateSettingsVersion(deviceId, new MeshSettingsVersionUpdateFactory().create(deviceId, settingsVersion))));
    }

    private final Observable<CloudMeshMessage> mapToMeshMessage(@NotNull Observable<MeshId> $receiver) {
        Observable observable = $receiver.flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ EstimoteCloudManager this$0;

            @NotNull
            public final Observable<CloudMeshMessage> apply(MeshId it) {
                CloudRestApi cloudRestApi = EstimoteCloudManager.access$getRestApi$p(this.this$0);
                Long l = it.getMeshId();
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                return cloudRestApi.getMeshMessage(l);
            }
            {
                this.this$0 = estimoteCloudManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMap { restApi.g\u2026eshMessage(it.meshId!!) }");
        return observable;
    }

    private final Observable<CloudMeshMessage> completeIfThereIsNoMessageForDevice(@NotNull Observable<CloudMeshMessage> $receiver) {
        Observable observable = $receiver.flatMapMaybe((Function)completeIfThereIsNoMessageForDevice.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMapMaybe { mess\u2026er.onSuccess(message) } }");
        return observable;
    }

    private final Observable<CloudMeshMessage> executeInBackground(@NotNull Observable<CloudMeshMessage> $receiver) {
        Observable observable = $receiver.subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.subscribeOn(Schedulers.io())");
        return observable;
    }

    private final Completable executeInBackground(@NotNull Completable $receiver) {
        Completable completable = $receiver.subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.subscribeOn(Schedulers.io())");
        return completable;
    }

    private final Observable<CloudMeshMessage> notifyOnMainThread(@NotNull Observable<CloudMeshMessage> $receiver) {
        Observable observable = $receiver.observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.observeOn(AndroidSchedulers.mainThread())");
        return observable;
    }

    private final Completable notifyOnMainThread(@NotNull Completable $receiver) {
        Completable completable = $receiver.observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.observeOn(AndroidSchedulers.mainThread())");
        return completable;
    }

    public EstimoteCloudManager(@NotNull CloudRestApi restApi) {
        Intrinsics.checkParameterIsNotNull((Object)restApi, (String)"restApi");
        this.restApi = restApi;
    }

    @NotNull
    public static final /* synthetic */ CloudRestApi access$getRestApi$p(EstimoteCloudManager $this) {
        return $this.restApi;
    }
}

