package com.estimote.cloud_plugin.internal.rest.gson

import com.estimote.cloud_plugin.internal.dagger.model.MeshId
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import java.lang.reflect.Type

class MeshIdDeserializer: JsonDeserializer<MeshId> {

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): MeshId {
        return MeshId(json?.asJsonObject?.getData()?.getSettings()?.getAdvertisers()?.getMeshData()?.getMeshId())
    }

    private fun JsonObject.getData(): JsonObject? = this.get("data")?.asJsonObject

    private fun JsonObject.getSettings(): JsonObject? = this.get("settings")?.asJsonObject

    private fun JsonObject.getAdvertisers(): JsonObject? = this.get("advertisers")?.asJsonObject

    private fun JsonObject.getMeshData(): JsonObject? = this.get("mesh")?.asJsonArray?.get(0)?.asJsonObject

    private fun JsonObject.getMeshId(): Long? = this.get("mesh_identifier")?.asLong
}