package com.estimote.cloud_plugin.internal.rest.gson

import com.estimote.cloud_plugin.internal.dagger.model.MeshId
import com.estimote.internal_plugins_api.cloud.CloudMeshMessage
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.reflect.TypeToken


class GsonFactory {
    fun createGson(): Gson {
        return GsonBuilder()
                .registerTypeAdapter(object : TypeToken<CloudMeshMessage>() {}.type, CloudMessageDeserializer())
                .registerTypeAdapter(object : TypeToken<MeshId>() {}.type, MeshIdDeserializer())
                .enableComplexMapKeySerialization()
                .serializeNulls()
                .setPrettyPrinting()
                .create()
    }
}
