package com.estimote.cloud_plugin.internal.rest.gson

import com.estimote.coresdk.repackaged.okio_v1_3_0.okio.ByteString
import com.estimote.internal_plugins_api.cloud.CloudMeshMessage
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import java.io.InvalidObjectException
import java.lang.reflect.Type

class CloudMessageDeserializer : JsonDeserializer<CloudMeshMessage> {
    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): CloudMeshMessage {
        return CloudMeshMessage(
                getMeshMessageBufferBytes(getMeshMessageDataStringProperty("message_buffer", json)),
                getSettingsVersionBytes(getMeshMessageDataStringProperty("settings_version", json)))
    }

    private fun getMeshMessageBufferBytes(messageBufferString: String) =
            ByteString.decodeHex(messageBufferString).toByteArray()

    private fun getSettingsVersionBytes(settingsVersionString: String): Long {
        return settingsVersionString.toLongOrNull() ?: throw InvalidObjectException("Unable to get settings_version value form received json")
    }

    private fun getMeshMessageDataStringProperty(propertyName: String, json: JsonElement?): String =
            json?.asJsonObject?.getData()?.getProperty(propertyName) ?: ""

    private fun JsonObject.getData(): JsonObject? =
            this.get("data")?.asJsonObject

    private fun JsonObject.getProperty(propertyName: String): String? =
            if (this.get(propertyName) == null || this.get(propertyName).isJsonNull) null
            else this.get(propertyName).asString
}